***********************************************************************
*** Table 2: Results from different specifications ***
***********************************************************************

* Housekeeping 
clear all 
use "$dataPath\Data"
do "$codePath\Transforming_variables"

regress global_credit_gap pcredit_gdp_gap
predict interak1, res

regress global_hp_gap hp_inc_gap
predict interak2, res

replace global_credit_gap = interak1
replace global_hp_gap = interak2

** Column(1)
logit crisis4_12 dlogreal_pcredit hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap gdp_gap i.country_id, robust cluster(period)
est store p1
predict p1, p
bysort start_crisis : count if p1 !=.
roctab crisis4_12 p1
estadd scalar AUROC = r(area)
estadd scalar AUROC_se = r(se)
estadd scalar Countries = 20
estadd scalar Crisis = 29
gen crisis_prob = p1
gen nr_countries = 20
gen Model  = 1
preserve
drop country_id
egen country_id = group(country)
** This is to calculate model evaluation measures 
do "$codePath\stats"
cd "$outputPath" 
keep if country == "USA"
keep if quarter == 140
keep TPR90 TPR95 FPR90 FPR95 Rel_use90 Rel_use95 Model
save stats, replace
restore


** Column (2)

logit crisis4_12 dlogreal_pcredit hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap gdp_gap global_credit_gap global_hp_gap i.country_id, robust cluster(period)
est store p2
predict p2, p
bysort start_crisis : count if p2 !=.
roctab crisis4_12 p2
estadd scalar AUROC = r(area)
estadd scalar Countries = 17
estadd scalar Crisis = 25
replace crisis_prob = p2
replace nr_countries = 17
replace Model  = 2
preserve
drop if country == "DNK" || country == "GRC" || country == "PRT" 
drop country_id
egen country_id = group(country)
** This is to calculate model evaluation measures 
do "$codePath\stats"
cd "$outputPath" 
keep if country == "USA"
keep if quarter == 140
keep TPR90 TPR95 FPR90 FPR95 Rel_use90 Rel_use95 Model
save help, replace
append using stats
save stats, replace 
restore

** Column (3)
logit crisis4_12 dlogreal_pcredit hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap gdp_gap global_credit_gap global_hp_gap ind_hp_inc_exu ind_credit_gdp_exu i.country_id , robust cluster(period)
est store p3
predict p3, p
bysort start_crisis : count if p3 !=.
roctab crisis4_12 p3
estadd scalar AUROC = r(area)
estadd scalar Countries = 15
estadd scalar Crisis = 22
replace crisis_prob = p3
replace nr_countries = 15
replace Model  = 3
preserve 
drop if country == "DNK" ||  country == "GRC"  || country == "PRT" || country == "AUT" || country == "CAN" 
drop country_id
egen country_id = group(country)
** This is to calculate model evaluation measures 
do "$codePath\stats"
cd "$outputPath" 
keep if country == "USA"
keep if quarter == 140
keep TPR90 TPR95 FPR90 FPR95 Rel_use90 Rel_use95 Model
save help, replace
append using stats
save stats, replace
restore

**Column (4)

logit crisis4_12 dlogreal_pcredit hcredit_gdp_gap nfecredit_gdp_gap global_credit_gap global_hp_gap hp_inc_gap gdp_gap ind_hp_inc_exu ind_credit_gdp_exu wholesale_gap equity_assets i.country_id, robust cluster(period)
est store p4
predict p4, p
bysort start_crisis : count if p4 !=.
roctab crisis4_12 p4
estadd scalar AUROC = r(area)
estadd scalar Countries = 13
estadd scalar Crisis = 19
replace crisis_prob = p4
replace nr_countries = 13
replace Model  = 4
preserve 
drop if country == "DNK" ||  country == "GRC" || country == "PRT" || country == "AUT" || country == "CAN" || country == "GBR" || country == "AUS"
drop country_id
egen country_id = group(country)
** This is to calculate model evaluation measures 
do "$codePath\stats"
cd "$outputPath" 
keep if country == "USA"
keep if quarter == 140
keep TPR90 TPR95 FPR90 FPR95 Rel_use90 Rel_use95 Model
append using stats
save stats, replace
outsheet using "stats_table2.csv", comma replace
restore


**Column (5)

* Creating interaction term
gen hp_bubble_cred_h      = ind_hp_inc_exu*hcredit_gdp_gap

logit crisis4_12 dlogreal_pcredit hcredit_gdp_gap hp_bubble_cred_h nfecredit_gdp_gap global_credit_gap global_hp_gap hp_inc_gap gdp_gap ind_credit_gdp_exu wholesale_gap equity_assets i.country_id, robust cluster(period)
est store p5
predict p5, p
bysort start_crisis : count if p5 !=.
roctab crisis4_12 p5
estadd scalar AUROC = r(area)
estadd scalar Countries = 13
estadd scalar Crisis = 19
replace crisis_prob = p5
replace nr_countries = 13
replace Model  = 5
preserve 
drop if country == "DNK" || country == "GRC" || country == "PRT" || country == "AUT" || country == "CAN" || country == "GBR" || country == "AUS"
drop country_id
egen country_id = group(country)
** This is to calculate model evaluation measures 
do "$codePath\stats"
cd "$outputPath" 
keep if country == "USA"
keep if quarter == 140
keep TPR90 TPR95 FPR90 FPR95 Rel_use90 Rel_use95 Model
append using stats
save stats, replace
* Saving measures of relative usefulness, true positive rates, false positive rates in csv file (added "manually" to tex file)
outsheet using "stats_table2.csv", comma replace
restore


* All output is saved as a LaTex file
cd "$outputTables"
esttab p1 p2 p3 p4 p5 using Table2.tex, se indicate("Country fixed effects = *country_id") drop(_cons) ///
											   order(dlogreal_pcredit hcredit_gdp_gap hp_bubble_cred_h nfecredit_gdp_gap global_credit_gap global_hp_gap ind_hp_inc_exu ind_credit_gdp_exu wholesale_gap equity_assets hp_inc_gap gdp_gap ) ///
											   star(* 0.1 ** 0.05 *** 0.01) obslast varwidth(30) wrap nomtitles ///
											   label scalars("r2_p Pseudo R-Squared" AUROC Countries Crisis) ///
											   nodepvars nonotes replace


											   
